//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
void OnStart(void)
{
    int     handle;

    const datetime dt = D'31.10.2024 15:30:10';
    const int i32 = 356248;

    if ((handle = FileOpen("Hello World.txt", FILE_WRITE | FILE_READ | FILE_ANSI | FILE_BIN)) == INVALID_HANDLE)
    {
        Print("Error...");
        return;
    };
    FWriteString(handle, (string)i32);
    FWriteString(handle, "info");
    FWriteString(handle, StringFormat("%s", TimeToString(dt, TIME_DATE | TIME_SECONDS)));

    FileFlush(handle);
    
    FileSeek(handle, 0, SEEK_SET);
    while (!FileIsEnding(handle))
    {
        uchar old = (uchar) FileReadInteger(handle, CHAR_VALUE);
        Print(old, " || ", FileTell(handle), " >> ", FileReadString(handle, old));
    }

    FileClose(handle);
}
//+------------------------------------------------------------------+
void FWriteString(int &handle, const string szArg)
{
    long offs = (long) FileWriteInteger(handle, 0, CHAR_VALUE);
    long size = (long) FileWriteString(handle, szArg);
    ulong ftell = FileTell(handle);
    FileSeek(handle, (size + offs) * -1, SEEK_CUR);
    FileWriteInteger(handle, (uchar)size, CHAR_VALUE);
    FileSeek(handle, ftell, SEEK_SET);
}
//+------------------------------------------------------------------+